/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles.sona;

import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import entities.creatures.EnemyCreatureEntity;
import entities.creatures.enemies.MinionEntity;
import entities.creatures.player.SonaEntity;
import entities.missiles.MissileEntity;
import java.util.ArrayList;
import util.Config;

public final class SonaAbilityREntity
extends MissileEntity {
    private ArrayList<CreatureEntity> entities = new ArrayList();
    private boolean globalStunDone = false;

    public SonaAbilityREntity(SonaEntity parent, GameState game, int x, int y) {
        super(parent, game, "missiles/sona/abilityR", x, y);
        this.dy = this.moveSpeed = (double)(-Math.min(Config.get(Config.sonaAbilityRProjectileSpeed) + Config.get(Config.sonaAbilityRCooldownPerLevel) * game.getLevel(), Config.get(Config.sonaAbilityRProjectileSpeedCap)));
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof EnemyCreatureEntity && !this.entities.contains(other)) {
            this.entities.add((CreatureEntity)other);
            if (((CreatureEntity)other).hasEffectType("spellshield")) {
                ((CreatureEntity)other).removeEffectByType("spellshield");
                this.globalStunDone = true;
            } else {
                ((CreatureEntity)other).damage(this, Config.get(Config.sonaAbilityRDamage) + Config.get(Config.sonaAbilityRDamagePerLevel) * this.game.getLevel());
                ((CreatureEntity)other).stun(Math.max(Config.get(Config.sonaAbilityRStunDuration) + Config.get(Config.sonaAbilityRStunDurationPerLevel) * this.game.getLevel(), Config.get(Config.sonaAbilityRStunDurationCap)));
                if (!this.globalStunDone) {
                    this.globalStunDone = true;
                    ArrayList<Entity> entities = this.game.getEntities();
                    int i = 0;
                    while (i < entities.size()) {
                        Entity entity = entities.get(i);
                        if (entity instanceof MinionEntity) {
                            ((MinionEntity)entity).stun(Math.max(Config.get(Config.sonaAbilityRStunDuration) + Config.get(Config.sonaAbilityRStunDurationPerLevel) * this.game.getLevel(), Config.get(Config.sonaAbilityRStunDurationCap)));
                        }
                        ++i;
                    }
                }
            }
        }
    }
}

